# finaquant Financial Analytics - www.finaquant.com
# Tunc Ali Ktkcoglu  2012, version: 12Mar2012
# TITLE: Quick Reference Guide to R
# Related web page:
# http://finaquant.com/quick-start-rer-matlab-and-r/599

# How to run this script:
# Ensure that this file is in the current working directory of R
# See menu "File/Change dir" if necessary
# Execute script by entering command: >source('R_quick_reference.r')

# special keys:
# upward arrow: next command in command history
# downward arrow: previous arrow in command history

# open general help document (online)
# >help.start()
# get help for a specific function or word
# >help('min') # or
# >?min
# search for keywords
# >help.search('optimization') # or
# >??optimization

# help function for displaying variables
display_variable = function(v, vname) 
{ 
print(paste(vname,' ='),quote = FALSE)
print(v,quote = FALSE)
}

print('Current directory:');
print(getwd())

print('***********************************************************',quote = FALSE);
print('Create vectors',quote = FALSE)
print('***********************************************************',quote = FALSE);
# create vector with four elements
v = c(1, 3, 6, 9)
display_variable(v,'v')

# Series: seq(StartValue,EndValue,Interval)
v_series_1to5 = 1:5;
display_variable(v_series_1to5,'v_series_1to5')
v_series_10to5 = seq(10,5,-1)
display_variable(v_series_10to5,'v_series_10to5')

# vector with multiple (repeating) constant values
v_4times3 = rep(3,4)
display_variable(v_4times3,'v_4times3')

# horizontal and vertical vectors
# R doesn't make a distinction between vertical and horizontal vectors. A "vector" is not a "matrix" for R.

print('***********************************************************',quote = FALSE);
print('Create matrices',quote = FALSE)
print('***********************************************************',quote = FALSE);
# 2x3 matrix with given element values
# fill values row-wise
D_byrow_2x3 = matrix(c(1,2,3,4,5,6),nrow=2,byrow=TRUE)
display_variable(D_byrow_2x3,'D_byrow_2x3')
# fill values column-wise
D_bycol_2x3 = matrix(c(1,4,2,5,3,6), nrow=2)
display_variable(D_bycol_2x3,'D_bycol_2x3')

# Create 2x4 matrix with random elements (values uniformly distributed between 0 and 1)
A_rand_2x4 = matrix(runif(2*4),2,4)
display_variable(A_rand_2x4,'A_rand_2x4')

# 1x3 matrix with all 5s
B_all5_1x3 = matrix(5,1,3)
display_variable(B_all5_1x3,'B_all5_1x3')
# 3x2 matrix with all 0s
C_all0_3x2 = matrix(0,3,2)
display_variable(C_all0_3x2,'C_all0_3x2')

print('***********************************************************',quote = FALSE);
print('Show all predefined variables',quote = FALSE)
print('***********************************************************',quote = FALSE);
print(ls())

print('***********************************************************',quote = FALSE);
print('Size of matrix',quote = FALSE)
print('***********************************************************',quote = FALSE);
# create a 3x4 matrix
A = floor(100 * matrix(runif(3*4),3,4))
# number of rows
rows = nrow(A)
display_variable(rows,'rows')
# number of columns
cols = ncol(A)
display_variable(cols,'cols')
# maximum dimension (max(#row, #col))
maxdim = max(dim(A))
display_variable(maxdim,'maxdim')
# total number of elements in a vector
v = c(1,2,3,4)
vlen = length(v)
display_variable(vlen,'vlen')
# total number of elements in a matrix
noofelements = length(A)
display_variable(noofelements,'noofelements')
# dimensions of a vector
dimvec = dim(c(1,2,3))
display_variable(dimvec,'dimvec')

print('***********************************************************',quote = FALSE);
print('Access elements of a vector or matrix',quote = FALSE)
print('***********************************************************',quote = FALSE);
v = c(3,5,8,11,16)
display_variable(v,'v')
# second element of vector
v_e2 = v[2]
display_variable(v_e2,'v_e2')
# elements with indices from 2 to 4
v_e2to4 = v[2:4]
display_variable(v_e2to4,'v_e2to4')
# elements with indices 2,3,5
v_e235 = v[c(2,3,5)]
display_variable(v_e235,'v_e235')
# access element of a matrix with row and column index
A = floor(100 * matrix(runif(3*4),3,4))
display_variable(A,'3x4 matrix A')
A_e23 = A[2,3]
display_variable(A_e23,'A_e23')
# selected rows of a matrix
A_rows13 = A[c(1,3),]
display_variable(A_rows13,'A_rows13')
# selected rows and columns of a matrix
A_rows13_cols23 = A[c(1,3),c(2,3)]
display_variable(A_rows13_cols23,'A_rows13_cols23')

print('***********************************************************',quote = FALSE);
print('Transpose vectors or matrices',quote = FALSE)
print('***********************************************************',quote = FALSE);
# Transpose operation converts a vector into a horizontal (1xN) matrix 
v = c(2,4,6,9)
display_variable(v,'v')
v_transpose = t(v)
display_variable(v_transpose,'v_transpose')
# transpose matrix
D = matrix(c(1,4,2,5,3,6), nrow=2)
display_variable(D,'D')
D_transpose = t(D)
display_variable(D_transpose,'D_transpose')

print('***********************************************************',quote = FALSE);
print('Add column(s) or row(s) to a matrix',quote = FALSE)
print('***********************************************************',quote = FALSE);
X = matrix(c(1,2,3,4), nrow=2,byrow=TRUE)
display_variable(X,'X')
# horizontal (column-wise) concatenation
V = matrix(c(5,10), nrow=2)
display_variable(V,'V')
X_V_horizontal = cbind(X,V)
display_variable(X_V_horizontal,'X_V_horizontal')
# vertical (row-wise) concatenation
W = matrix(c(5,10), nrow=1) 
display_variable(W,'W')
X_W_vertical = rbind(X,W)
display_variable(X_W_vertical,'X_W_vertical')

print('***********************************************************',quote = FALSE);
print('Insert a matrix into another matrix',quote = FALSE)
print('***********************************************************',quote = FALSE);
X = matrix(c(1,2,3,4,5,6,7,8),nrow=2,byrow=TRUE)
display_variable(X,'X')
M = X
# insert by replacing elements (element assignment)
Y = matrix(c(10,11,12,13), nrow=2,byrow=TRUE)
display_variable(Y,'Y')
M[,c(2,3)] = Y
display_variable(M,'X_insert_Y')
# insert by (horizontal) concatenation
X_extend_by_Y = cbind(X[,1], Y, X[,2:4])
display_variable(X_extend_by_Y,'X_extend_by_Y')

print('***********************************************************',quote = FALSE);
print('Basic matrix operations',quote = FALSE)
print('***********************************************************',quote = FALSE);
X = matrix(c(2,4,9,16,25,36), nrow=2,byrow=TRUE)
display_variable(X,'X')
# square root of all elements
X_square_root = sqrt(X)
display_variable(X_square_root,'X_square_root')
# square of all elements
X_square = X * X # or X ^2
display_variable(X_square,'X_square')
# matrix matrix multiplication %*%
V = matrix(c(1,2,3), nrow=3)
display_variable(V,'V')
XxV = X %*% V
display_variable(XxV,'XxV')
# matrix scalar multiplication
Xx5 = 5 * X
display_variable(Xx5,'Xx5')
# matrix scalar division
Xdiv10 = X / 10
display_variable(Xdiv10,'Xdiv10')
# elementwise multiplication
XxX_elementwise = X * X
display_variable(XxX_elementwise,'XxX_elementwise')
# inverse matrix
A = matrix(c(1,3,2,4), nrow=2,byrow=TRUE)
display_variable(A,'A')
Ainv = solve(A)
display_variable(Ainv,'Ainv')
# test inverse matrix
AxAinv = A %*% Ainv
display_variable(AxAinv,'AxAinv')

print('***********************************************************',quote = FALSE);
print('Solve a typical matrix equation: A x b = c --> b = ?',quote = FALSE)
print('***********************************************************',quote = FALSE);
A = matrix(c(1,2,3,4), nrow=2,byrow=TRUE)
display_variable(A,'A')
c = matrix(c(1,2), nrow=2)
display_variable(c,'c')
b = solve(A) %*% c
display_variable(b,'b')
# Test the result
Axb = A %*% b
display_variable(Axb,'Axb')

print('***********************************************************',quote = FALSE);
print('Sorting matrices',quote = FALSE)
print('***********************************************************',quote = FALSE);
X = matrix(c(3,5,2,7,1,10,12,5,3,2,8,10,1,6,4,2),nrow=4,byrow=TRUE)
display_variable(X,'X')
# sort rows after first column
X_sort_col1_ascend = X[order(X[,1]),]
# sort rows after first column in descending order
X_sort_col1_descend = X[order(-X[,1]),]
# sort rows after first and second columns
X_sort_cols12 = X[order(X[,1],X[,2]),]
# sort columns after the first row
X_sort_row1_ascend = X[,order(X[1,])]

print('***********************************************************',quote = FALSE);
print('Sorting vectors',quote = FALSE)
print('***********************************************************',quote = FALSE);
v = c(2,5,1,4)
display_variable(v,'v')
# sort vector in ascending order
# w: sorted vector
# ind: element indices such that w = v(ind)
res=sort(v,index.return=TRUE) 
w = res$x 
display_variable(w,'sorted vector w')
ind = res$ix
display_variable(ind,'ind')
display_variable(v[ind],'v[ind]')

print('***********************************************************',quote = FALSE);
print('Aggregation functions like sum, mean, max, min, stdev, variance',quote = FALSE)
print('***********************************************************',quote = FALSE);
X = matrix(c(1,4,2,3,6,2), nrow=2,byrow=TRUE)
display_variable(X,'X')
# sum of each column (columnwise sum)
X_col_sum = colSums(X)
display_variable(X_col_sum,'X_col_sum')
X_row_sum = rowSums(X)
display_variable(X_row_sum,'X_row_sum')
# Note that the functions colSums() and rowSums() returns vectors; not matrices. 
# sum of all elements of a matrix
display_variable(sum(X),'X_sum')
# mean value of each column
display_variable(colMeans(X),'X_col_means')
# mean value of each row
display_variable(rowMeans(X),'X_row_means')
# see other functions like apply(X,1,sd), apply(X,1,var), cov() and median() in R

print('***********************************************************',quote = FALSE);
print('Text output to console',quote = FALSE)
print('***********************************************************',quote = FALSE);
# display simple text only
print('this is a sentence')
# text concatenate
str = paste('motor ','car','s',sep='')
print(str)
v = c(1,2,3,4) 
print(paste('v =', paste(as.character(v),collapse=' ')),quote = FALSE)
# text output with an integer parameter
str = sprintf('a is equal to %d', 5); print(str,quote = FALSE);
# text output with a floating number
str = sprintf('b is equal to %f', sqrt(2)); print(str,quote = FALSE);
# number formatting: Show two decimals after fractional point
str = sprintf('b is equal to %.2f', sqrt(2)); print(str,quote = FALSE);
str = sprintf('Results: a = %d, b = %.1f, c = %.2f', 4, 5.18, 6.12); print(str,quote = FALSE);

print('***********************************************************',quote = FALSE);
print('Programming language constructs',quote = FALSE)
print('***********************************************************',quote = FALSE);
# while loop
v = c(8,5,3,7,2,8,1,2);
display_variable(v,'v')
# start from left, find the first number smaller than or equal to 2
i=1 
while (v[i]>2){ 
i=i+1 
} 
str=sprintf('Results: i = %d, v[i] = %d',i,v[i]) 
print(str)
# alternative method
a = which(v <= 2) 
i = a[1]
# look for which() in R help; it is a useful search function
# for loop
# generate identity matrix (all diagonal elements 1, others 0)
I = matrix(0, 3, 3)
for (i in 1:3) { 
I[i,i]=1 
}
display_variable(I,'I')
# alternative method
I = diag(3)
# if statements
x = 5;
# check if x is in range (2,10)
if ((x > 2) && (x < 10)) { 
print('x is in range') 
} else { 
print('x is not in range')
}
# see keywords like switch, ifelse, repeat and next for other programming constructs 

print('***********************************************************',quote = FALSE);
print('Writing scripts and functions',quote = FALSE)
print('***********************************************************',quote = FALSE);
# this very file itself is an example script

# function with multiple arguments and a single return value
difference = function(a,b) { return(a - b) }
# calling the function
# use source(filepath) to include the function if it is defined in another file
display_variable(difference(10,2),'difference(10,2)')

# function with multiple return values
sumdif = function(a,b) { 
s = a + b 
d = a - b 
return(list(s, d)) }
# calling the function
# use source(filepath) to include the function if it is defined in another file
results = sumdif(5,3)
s = results[[1]]
d = results[[2]]
display_variable(s,'sumdif(5,3) sum')
display_variable(d,'sumdif(5,3) difference')

print('***********************************************************',quote = FALSE);
print('Plotting graphs',quote = FALSE)
print('***********************************************************',quote = FALSE);
# Just move the window of the last one to see every figure; 
# multiple figures may come exactly on top of each other.

# plot x-square function
x=1:100
y = x * x
plot(x, y, type='l',xlab='x',ylab='y',main='y = x-square')
dev.new()  # opens a new diagram so that the previous one is not overwritten

# plot two curves on the same graph
# first curve is red, second is blue
x = 1:100 
y1 = x ^2 
y2 = (x-5)^2 
plot(x,y1,type="l",col="red",xlab='x',ylab='y1 and y2',main='two curves') 
lines(x,y2,col="blue")
dev.new()  # opens a new diagram so that the previous one is not overwritten

# histogram
# random number with normal distribution
x = rnorm(10000, sd=4, mean=5); 
hist(x,main='rnorm(10000, sd=4, mean=5)')
dev.new()  
# random number with uniform distribution
x = runif(10000); 
hist(x,main='runif(10000)')
dev.new()  

# z = (x + 0.5*y - 5) ^ 2
x = seq(0, 5, 0.1) 
y = seq(0, 10, 0.2) 
f = function(x,y) return((x + 0.5*y -5)^2) 
z = outer(x,y,f)
# surface plot 
persp(x,y,z,main='SURFACE: z = (x + 0.5*y - 5) ^ 2')
dev.new() 
# contour lines (level curves)
contour(x,y,z,main='CONTOUR: z = (x + 0.5*y - 5) ^ 2')

print('***********************************************************',quote = FALSE);
print('Constrained optimization',quote = FALSE)
print('***********************************************************',quote = FALSE);
# General syntax: # x = constrOptim(x0, fun, grad, A, b, )
#- fun: single-output objective function whose return is to be minimized
#- x0: start value for vector x
#- inequality constraint: Ax = b
#- grad: gradient function for fun. It can be "null" if it is not known.

# Constrained optimization problem:
# Minimize z = sin(x + 0.5y) subject to constraints:
# x + y = 5 and x - y = 2

print('STEP 1: Create objective function objfun')
# Note: x --> v(1), y --> v(2)
objfun = function(v) { 
z = sin(v[1] + 0.5*v[2]) 
return(z) 
}
# test objfun
display_variable(objfun(c(2,5)),'objfun(c(2,5))')

print('STEP 2: Formulate boundary conditions')
# x + y = 5
# x - y = 2 --> -x + y = -2
A = matrix(c(1,1,-1,1), 2,2,byrow=TRUE) 
display_variable(A,'A')
b = matrix(c(5,-2),2,1)
display_variable(b,'b')
grad = NULL
display_variable(grad,'grad')
# set a starting point for vector v
# Note: initial value should satisfy the boundary conditions
v0 = c(3,4)

# STEP 3: Run optimization function
result = constrOptim(v0, objfun, grad, A, b)
# Test the result
# Value of objective function at this point v
v = result[[1]]
display_variable(objfun(v),'objfun(v)')
# Inequality condition 1: check if x + y = 5
display_variable(sum(v),'sum(v)')
# Inequality condition 2: check if x - y = 2
display_variable(v[1]-v[2],'v[1]-v[2]')

# finaquant Financial Analytics - www.finaquant.com
# Tunc Ali Ktkcoglu  2012